#include <stdrom.h>
#include <define.h>
#include <libc.h>

#define FILENAME "SHARED"
static char filename[]=FILENAME;

static byte mode=0;
static byte submode=0;

int sffindfile(FILE_BUF *fb)
{
  /* open or create shared data file */
  if (mode==0)
    {
      if (!LibGetAllEntry(filename,&mode,&submode)) /* find shared file */
	{
	  if (!LibSubEntrySave(filename,&submode)) return FALSE; /* create new */
	  LibGetAllEntry(filename,&mode,&submode);/* get mode and submode */
	}
    }
  /* Set main and sub entry mode in fb*/
  fb->fsb_main_entry_ = mode;
  fb->fsb_sub_entry_  = submode;
  fb->fsb_scrt_info_  = 0x80;  /* Open Mode */
  return TRUE;
}
  
int sffindrecord(char *signature,FILE_BUF *fb,FILE_INFO *fi)
{
  /* search named record and load it*/
  int found=FALSE;
  fi->fp = 0xffff;             /* first search */    
  fi->kind = FILE_KIND_BIN;    /* binary file */
  
  LibFileFindNext(fb,fi,0);
  while ((!found) && (fi->fp!=0xffff))
    {
      if (!LibFileReadEx(fb,fi,3072/FILE_BLOCK_SIZE)) 
	return FALSE; /* Read error */
      found = strcmp(fb->fbuf.bin.bin_buf,signature)==0; /*compare signature*/
      if (!found) LibFileFindNext(fb,fi,0);
    }
  if (!found) 
    {
      fi->fp = 0xffff;             /* prepare FILE_INFO for "write new" */  
      fi->kind = FILE_KIND_BIN;    /* binary file */
    }
  return found;
}

byte *sfgetdatapointer(FILE_BUF *fbuf,int *freebytes)
{
  /* pointer to real data */
  byte *ptr=fbuf->fbuf.bin.bin_buf;
  *freebytes=3*1024;
  while (*ptr!=0) 
    {
      ptr++;   /* skip signature */
      (*freebytes)--;
    }
  ptr++;                   /* skip null byte */
  (*freebytes)--;
  return ptr;
}

int sfLoadRecord(char *signature,int size,byte far *buffer)
{
  int i;
  int bytes;
  FILE_INFO fi;
  FILE_BUF fbuf;                     /* requires very much stack space */
  byte *sptr;
  byte far *dptr;
  
  if (! sffindfile(&fbuf)) return FALSE;   /* find shared file */
  if (! sffindrecord(signature,&fbuf,&fi)) /* find and load record */   
    return FALSE;

  bytes=fbuf.fbuf.bin.char_num;            /* number of data bytes */
  sptr = fbuf.fbuf.bin.bin_buf;
  while (*sptr!=0) { sptr++; bytes--; }    /* find end of signature */
  sptr++; bytes--;                         /* skip null byte */

  dptr = buffer;

  /*  if (size>bytes) size=bytes; */
  for (i=0;i<size;i++)         /* move data to buffer */
    {
      if (bytes>0) *(dptr++)=*(sptr++);
      else *(dptr++)=0;
      bytes--; 
    }
  return TRUE;
}

int sfSaveRecord(char *signature,int size,byte far *buffer)
{
  int i;
  FILE_INFO fi;
  FILE_BUF fbuf;                  /* requires very much stack space */
  byte far *sptr;
  byte *dptr;
  int freebytes;

  if (!sffindfile(&fbuf)) return FALSE;      /* find or create shared file */
  sffindrecord(signature,&fbuf,&fi);         /* find record, but ignore error*/
 
  strcpy(fbuf.fbuf.bin.bin_buf,signature);   /* Write signature to filebuffer*/
  sptr=buffer;
  dptr=sfgetdatapointer(&fbuf,&freebytes);   /* get pointer to data */
  if (size>freebytes) return FALSE;          /* size too big error */

  for (i=0;i<size;i++)                       /* move data to filebuffer */
    *(dptr++)=*(sptr++);

  fbuf.fbuf.bin.char_num = dptr-fbuf.fbuf.bin.bin_buf; /* store size in filebuffer */

  return LibFileWrite(&fbuf,&fi);            /* write record */
}

